/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.settings.autologon;

import com.ibm.hwmca.base.managed.BaseTower;
import com.ibm.hwmca.base.settings.autologon.CustomizeAutomaticLogonBean;
import com.ibm.hwmca.base.settings.autologon.CustomizeAutomaticLogonConstants;
import com.ibm.hwmca.base.settings.autologon.CustomizeAutomaticLogonErrorIds;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.ClassId;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.User;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.ui.framework.TaskActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;

public class CustomizeAutomaticLogonTasklet
extends PanelTasklet
implements CustomizeAutomaticLogonErrorIds,
CustomizeAutomaticLogonConstants {
    private static final String TRACE_MASKT = "XCALTSKT";
    private static final String TRACE_MASKF = "XCALTSKF";
    private static final String TRACE_MASKD = "XCALTSKD";
    private static final String AUIML_FILE_NAME = "com.ibm.hwmca.base.settings.autologon.res.CustomizeAutomaticLogonRes";
    private static final String CUSTOMIZE_AUTOMATIC_LOGON_PANEL_NAME = "CustomizeAutomaticLogonPanel";
    private static final String SETTINGS_FRAME_BEAN = "BASETOWERSETTINGSBEAN";
    private BaseTower baseTower = BaseTower.getBaseTower();
    private static final String PEMODE = "PEMODE";
    static /* synthetic */ Class class$com$ibm$hwmca$fw$managed$User;

    public CustomizeAutomaticLogonTasklet() {
        Trace.trace(TRACE_MASKT, "<> CustomizeAutomaticLogonTasklet.CustomizeAutomaticLogonTasklet()");
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> CustomizeAutomaticLogonTasklet.service(" + request + ", " + response + ")");
        if (request.isInitialRequest()) {
            ArrayList<String> userArrayList = new ArrayList<String>();
            Set users = this.getAllUsers();
            Trace.trace(TRACE_MASKF, "CustomizeAutomaticLogonTasklet.service(): The managed object manager returned " + users.size() + " users.");
            Iterator iterator = users.iterator();
            while (iterator.hasNext()) {
                Object object = iterator.next();
                if (!(object instanceof User)) continue;
                User user = (User)object;
                String userid = user.getUserName().toUpperCase();
                Trace.trace(TRACE_MASKF, "CustomizeAutomaticLogonTasklet.service(): userid = " + userid);
                if (userid.equalsIgnoreCase(PEMODE)) continue;
                Trace.trace(TRACE_MASKF, "CustomizeAutomaticLogonTasklet.service(): Adding userid \"" + userid + "\" to the list of userids for automatic logon.");
                userArrayList.add(userid);
            }
            Collections.sort(userArrayList);
            CustomizeAutomaticLogonBean bean = new CustomizeAutomaticLogonBean();
            bean.setUserArrayList(userArrayList);
            if (this.baseTower.isAutoLogonEnabled()) {
                bean.setEnableAutomaticLogonToggle(true);
            } else {
                bean.setEnableAutomaticLogonToggle(false);
            }
            String autoLogonUser = this.baseTower.getAutoLogonUserid();
            if (userArrayList.size() != 0) {
                if (autoLogonUser == null) {
                    bean.setLogonChoice((String)userArrayList.get(0));
                } else {
                    boolean foundUser = false;
                    for (int i = 0; i < userArrayList.size(); ++i) {
                        if (!autoLogonUser.equals((String)userArrayList.get(i))) continue;
                        bean.setLogonChoice(autoLogonUser);
                        foundUser = true;
                        break;
                    }
                    if (!foundUser) {
                        bean.setLogonChoice((String)userArrayList.get(0));
                    }
                }
            }
            response.replace(AUIML_FILE_NAME, CUSTOMIZE_AUTOMATIC_LOGON_PANEL_NAME, bean);
        } else {
            TaskActionEvent event = (TaskActionEvent)request.getData("Event");
            if (event.getElementName().endsWith("OkButton") || event.getElementName().endsWith("ApplyButton")) {
                Boolean enable = (Boolean)request.getData("EnableAutomaticLogonToggle");
                String logonchoice = (String)request.getData("LogonChoice");
                if (enable.booleanValue()) {
                    this.baseTower.setAutoLogon(true);
                } else {
                    this.baseTower.setAutoLogon(false);
                }
                this.baseTower.setAutoLogonUserid(logonchoice);
                if (event.getElementName().endsWith("OkButton")) {
                    PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                    panelTaskletRequest.setDisposed();
                    if (this.isSubtasklet()) {
                        this.getParent().postRequest(SETTINGS_FRAME_BEAN, panelTaskletRequest);
                    }
                    response.terminate();
                } else {
                    response.noAction();
                }
            } else if (event.getElementName().endsWith("CancelButton")) {
                PanelTaskletRequest panelTaskletRequest = new PanelTaskletRequest();
                panelTaskletRequest.setDisposed();
                if (this.isSubtasklet()) {
                    this.getParent().postRequest(SETTINGS_FRAME_BEAN, panelTaskletRequest);
                }
                response.terminate();
            }
        }
        Trace.trace(TRACE_MASKT, "<- CustomizeAutomaticLogonTasklet.service()");
    }

    public Set getAllUsers() {
        Trace.trace(TRACE_MASKT, "<> CustomizeAutomaticLogonTasklet.getAllUsers()");
        return ManagedObjectManager.getManagedObjectManager().getInventory(new ClassId(class$com$ibm$hwmca$fw$managed$User == null ? (class$com$ibm$hwmca$fw$managed$User = CustomizeAutomaticLogonTasklet.class$("com.ibm.hwmca.fw.managed.User")) : class$com$ibm$hwmca$fw$managed$User));
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> CustomizeAutomaticLogonTasklet.logException(" + throwable + ")");
        new FrameworkLog(CustomizeAutomaticLogonErrorIds.LOGINFO, 1074, throwable).log();
        Trace.trace(TRACE_MASKT, "<- CustomizeAutomaticLogonTasklet.logException()");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

